/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.profile;

import com.ibm.hsc.auiml.databeans.common.PIVirtualEthernetPropertiesDialog;
import com.ibm.hsc.auiml.databeans.common.PIVirtualSCSIPropertiesDialog;
import com.ibm.hsc.auiml.databeans.common.PIVirtualSerialPropertiesDialog;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.client.PIVirtualEthernetDataBean;
import com.ibm.hsc.client.PIVirtualSCSIDataBean;
import com.ibm.hsc.client.PIVirtualSerialDataBean;
import com.ibm.hsc.client.PIVirtualSlotDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.NumberComparator;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PIProfileVirtualIODataBean
implements DataBean,
TaskActionListener,
TaskNotifyCompleteListener {
    private static final String VIRTUAL_ADAPTER_TABLE = "ProfileP06VirtualIO.VirtualAdapterTable";
    private static final String CREATE_TYPE_GROUP = "ProfileP06VirtualIO.CreateTypeGroup";
    private static final String ETHERNET_BUTTON = "EthernetLabel";
    private static final String SCSI_BUTTON = "SCSILabel";
    private static final String SERIAL_BUTTON = "SerialLabel";
    private static final String CREATE = "CreateButton";
    private static final String PROPERTIES = "PropertiesButton";
    private static final String DELETE = "DeleteButton";
    private static final String MAX_VSLOTS_TOO_SMALL = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "MAX_VSLOTS_TOO_SMALL");
    private static final String VIRTUAL_SLOT_ALREADY_USED = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "VIRTUAL_SLOT_ALREADY_USED");
    private static final String SLOTS_ZERO_AND_ONE_CANNOT_BE_MODIFIED = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "SLOTS_ZERO_AND_ONE_CANNOT_BE_MODIFIED");
    private static final String ETHERNET_ADAPTER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "ETHERNET_ADAPTER");
    private static final String CLIENT_SCSI_ADAPTER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "CLIENT_SCSI_ADAPTER");
    private static final String SERVER_SCSI_ADAPTER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "SERVER_SCSI_ADAPTER");
    private static final String CLIENT_SERIAL_ADAPTER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "CLIENT_SERIAL_ADAPTER");
    private static final String SERVER_SERIAL_ADAPTER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "SERVER_SERIAL_ADAPTER");
    private static final String UNKNOWN_ADAPTER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "UNKNOWN");
    private static final String CANNOT_REMOVE_REQUIRED_VIRTUAL_SLOT = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "CANNOT_REMOVE_REQUIRED_VIRTUAL_SLOT");
    private final String DLPAR = "DLPAR";
    private Hashtable m_slotHashtable = new Hashtable();
    private static final int COLUMN_SLOT_NUMBER = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_REQUIRED = 2;
    private PILPARProfileDataBean m_cimProfileBean;
    private PICECDataBean m_cimCecBean;
    private Map m_lparNamesAndIDs;
    private UserTaskManager m_utm;
    private int m_maxVirtualSlots;
    private int m_iTotalEth = 0;
    private int m_iTotalSerial = 2;
    private int m_iTotalScsi = 0;
    private SortedMap m_virtualAdapters;
    private ColumnDescriptor[] m_virtualAdapterTableStructure;
    private int[] m_virtualAdapterTableSelection;
    private String[] m_sVioChoiceSelection;
    private HashMap m_dialogMap;
    private String m_sModule = "PROFILE";
    private MOXContainerObj mObj;

    public PIProfileVirtualIODataBean(PICECDataBean pICECDataBean, PILPARProfileDataBean pILPARProfileDataBean, Map map) {
        this.m_cimProfileBean = pILPARProfileDataBean;
        this.m_cimCecBean = pICECDataBean;
        this.m_lparNamesAndIDs = map;
        this.m_maxVirtualSlots = 10;
        this.m_virtualAdapters = new TreeMap(new NumberComparator());
        this.m_virtualAdapterTableStructure = new ColumnDescriptor[0];
        this.m_virtualAdapterTableSelection = new int[0];
        this.m_sVioChoiceSelection = new String[0];
        this.m_dialogMap = new HashMap();
    }

    public void setMOXContainer(MOXContainerObj mOXContainerObj) {
        this.mObj = mOXContainerObj;
    }

    public MOXContainerObj getMOXContainer() {
        return this.mObj;
    }

    public void setModule(String string) {
        this.m_sModule = string;
    }

    public String getModule() {
        return this.m_sModule;
    }

    public void initTotals() {
        this.m_iTotalEth = 0;
        this.m_iTotalScsi = 0;
        this.m_iTotalSerial = 0;
    }

    public void compTotals() {
        Iterator iterator = this.m_virtualAdapters.entrySet().iterator();
        PIVirtualSlotDataBean pIVirtualSlotDataBean = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            pIVirtualSlotDataBean = (PIVirtualSlotDataBean)entry.getValue();
            int n = pIVirtualSlotDataBean.getConfigurationState().intValue();
            switch (n) {
                case 1: {
                    ++this.m_iTotalEth;
                    break;
                }
                case 2: {
                    ++this.m_iTotalScsi;
                    break;
                }
                case 3: {
                    ++this.m_iTotalSerial;
                }
            }
        }
    }

    public String getTotalEth() {
        return new Integer(this.m_iTotalEth).toString();
    }

    public void setTotalEth(String string) {
        try {
            this.m_iTotalEth = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_iTotalEth = 0;
        }
    }

    public String getTotalSerial() {
        return new Integer(this.m_iTotalSerial).toString();
    }

    public void setTotalSerial(String string) {
        try {
            this.m_iTotalSerial = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_iTotalSerial = 0;
        }
    }

    public String getTotalScsi() {
        return new Integer(this.m_iTotalScsi).toString();
    }

    public void setTotalScsi(String string) {
        try {
            this.m_iTotalScsi = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_iTotalScsi = 0;
        }
    }

    public void setMaxVirtualSlots(double d) throws IllegalUserDataException {
        this.m_maxVirtualSlots = (int)Math.rint(d);
    }

    public double getMaxVirtualSlots() {
        return this.m_maxVirtualSlots;
    }

    public void setVirtualAdapterTableSelection(int[] nArray) throws IllegalUserDataException {
        this.m_virtualAdapterTableSelection = nArray;
    }

    public int[] getVirtualAdapterTableSelection() {
        return this.m_virtualAdapterTableSelection;
    }

    public void setVioChoiceSelection(String[] stringArray) throws IllegalUserDataException {
        this.m_sVioChoiceSelection = stringArray;
    }

    public String[] getVioChoiceSelection() {
        return this.m_sVioChoiceSelection;
    }

    public void setVirtualAdapterTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(itemDescriptorArray[0].getTitle());
        PIVirtualSlotDataBean pIVirtualSlotDataBean = (PIVirtualSlotDataBean)this.m_virtualAdapters.get(unsignedInt16);
        boolean bl = new Boolean(itemDescriptorArray[2].getTitle());
        if (bl) {
            pIVirtualSlotDataBean.setRequired(new UnsignedInt8(2));
        } else {
            pIVirtualSlotDataBean.setRequired(new UnsignedInt8(1));
        }
    }

    public ItemDescriptor[] getVirtualAdapterTableRowAt(int n) {
        return this.dataBeanToItemDescriptors(this.getSlotFromIndex(n));
    }

    public int getVirtualAdapterTableRowCount() {
        return this.m_virtualAdapters.size();
    }

    public int getVirtualAdapterTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getVirtualAdapterTableRowStructure() {
        return this.m_virtualAdapterTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        Map map;
        UnsignedInt16 unsignedInt16 = this.m_cimProfileBean.getMaxVirtualSlots();
        if (unsignedInt16 != null) {
            this.m_maxVirtualSlots = unsignedInt16.intValue();
        }
        if ((map = this.m_cimProfileBean.getVirtualEthernetAdapters()) != null) {
            this.m_virtualAdapters.putAll(map);
        }
        if ((map = this.m_cimProfileBean.getVirtualSCSIAdapters()) != null) {
            this.m_virtualAdapters.putAll(map);
        }
        if ((map = this.m_cimProfileBean.getVirtualSerialAdapters()) != null) {
            this.m_virtualAdapters.putAll(map);
        }
    }

    public SortedMap loadSlotsFromProfile(PILPARProfileDataBean pILPARProfileDataBean) {
        TreeMap treeMap = new TreeMap(new NumberComparator());
        Map map = pILPARProfileDataBean.getVirtualEthernetAdapters();
        if (map != null) {
            treeMap.putAll(map);
        }
        if ((map = pILPARProfileDataBean.getVirtualSCSIAdapters()) != null) {
            treeMap.putAll(map);
        }
        if ((map = pILPARProfileDataBean.getVirtualSerialAdapters()) != null) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public void verifyChanges() throws IllegalUserDataException {
        TreeSet treeSet = new TreeSet(new NumberComparator());
        treeSet.addAll(this.m_virtualAdapters.keySet());
        int n = ((UnsignedInt16)treeSet.last()).intValue();
        if (n >= this.m_maxVirtualSlots) {
            String string = MAX_VSLOTS_TOO_SMALL;
            throw new IllegalUserDataException(string);
        }
    }

    public void save() {
        this.m_cimProfileBean.setMaxVirtualSlots(new UnsignedInt16(this.m_maxVirtualSlots));
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        if (IDebug.enabled()) {
            System.err.println("PIProfileVirtualIODataBean.save(): Sorting adapters:");
        }
        Iterator iterator = this.m_virtualAdapters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            PIVirtualSlotDataBean pIVirtualSlotDataBean = (PIVirtualSlotDataBean)entry.getValue();
            int n = pIVirtualSlotDataBean.getConfigurationState().intValue();
            switch (n) {
                case 1: {
                    hashMap.put(entry.getKey(), pIVirtualSlotDataBean);
                    if (!IDebug.enabled()) break;
                    System.err.println("    Eth: " + pIVirtualSlotDataBean.toString());
                    break;
                }
                case 2: {
                    hashMap3.put(entry.getKey(), pIVirtualSlotDataBean);
                    if (!IDebug.enabled()) break;
                    System.err.println("    SCSI: " + pIVirtualSlotDataBean.toString());
                    break;
                }
                case 3: {
                    hashMap2.put(entry.getKey(), pIVirtualSlotDataBean);
                    if (!IDebug.enabled()) break;
                    System.err.println("    Ser: " + pIVirtualSlotDataBean.toString());
                }
            }
        }
        this.m_cimProfileBean.setVirtualEthernetAdapters(hashMap);
        this.m_cimProfileBean.setVirtualSCSIAdapters(hashMap3);
        this.m_cimProfileBean.setVirtualSerialAdapters(hashMap2);
        if (IDebug.enabled()) {
            System.err.println("Virtual I/O: " + this.m_cimProfileBean);
        }
    }

    public void setUserTaskManager(UserTaskManager userTaskManager) {
        this.m_utm = userTaskManager;
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        block14: {
            UserTaskManager userTaskManager = (UserTaskManager)taskActionEvent.getSource();
            String string = taskActionEvent.getActionCommand();
            if (IDebug.enabled()) {
                System.err.println("PIProfileVirtualIODataBean.actionPerformed: " + userTaskManager.toString() + ":" + string);
            }
            try {
                if (string.endsWith(PROPERTIES)) {
                    this.handleProperties(userTaskManager);
                    break block14;
                }
                if (string.endsWith(CREATE)) {
                    this.handleCreate(userTaskManager);
                    break block14;
                }
                if (string.endsWith(DELETE)) {
                    this.handleDelete(userTaskManager);
                    break block14;
                }
                if ("COMPLETE".equals(string)) {
                    DialogMapEntry dialogMapEntry = (DialogMapEntry)this.m_dialogMap.remove(userTaskManager);
                    if (IDebug.enabled()) {
                        System.err.println("Complete: Bean is: " + dialogMapEntry.m_cimBean.toString());
                    }
                    UnsignedInt16 unsignedInt16 = dialogMapEntry.m_cimBean.getSlotNumber();
                    PIVirtualSlotDataBean pIVirtualSlotDataBean = (PIVirtualSlotDataBean)this.m_virtualAdapters.get(unsignedInt16);
                    if (dialogMapEntry.isProperties()) {
                        if (dialogMapEntry.isReadOnly() || pIVirtualSlotDataBean != null && dialogMapEntry.m_cimBean != pIVirtualSlotDataBean) break block14;
                        if (pIVirtualSlotDataBean == null) {
                            Iterator iterator = this.m_virtualAdapters.entrySet().iterator();
                            int n = 0;
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                if (dialogMapEntry.m_cimBean == entry.getValue()) {
                                    iterator.remove();
                                    this.m_utm.removeRow(VIRTUAL_ADAPTER_TABLE, n);
                                    this.m_virtualAdapters.put(unsignedInt16, dialogMapEntry.m_cimBean);
                                    SortedMap sortedMap = this.m_virtualAdapters.headMap(unsignedInt16);
                                    this.m_utm.addRow(VIRTUAL_ADAPTER_TABLE, sortedMap.size(), this.dataBeanToItemDescriptors(dialogMapEntry.m_cimBean));
                                    break block14;
                                }
                                ++n;
                            }
                            break block14;
                        }
                        SortedMap sortedMap = this.m_virtualAdapters.headMap(unsignedInt16);
                        this.m_utm.removeRow(VIRTUAL_ADAPTER_TABLE, sortedMap.size());
                        this.m_utm.addRow(VIRTUAL_ADAPTER_TABLE, sortedMap.size(), this.dataBeanToItemDescriptors(dialogMapEntry.m_cimBean));
                        break block14;
                    }
                    if (dialogMapEntry.isCreate() && pIVirtualSlotDataBean == null) {
                        this.m_virtualAdapters.put(unsignedInt16, dialogMapEntry.m_cimBean);
                        SortedMap sortedMap = this.m_virtualAdapters.headMap(unsignedInt16);
                        this.m_utm.addRow(VIRTUAL_ADAPTER_TABLE, sortedMap.size(), this.dataBeanToItemDescriptors(dialogMapEntry.m_cimBean));
                    }
                    break block14;
                }
                if ("CANCEL".equals(string)) {
                    this.m_dialogMap.remove(userTaskManager);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                new TaskMessage(userTaskManager, throwable.getLocalizedMessage(), 1).invoke();
            }
        }
    }

    public void handleProperties(UserTaskManager userTaskManager) {
        if (IDebug.enabled()) {
            System.err.println("PIProfileVirtualIODataBean.handleProperties:");
        }
        ArrayList arrayList = new ArrayList(this.m_virtualAdapters.keySet());
        int[] nArray = userTaskManager.getSelectedRows(VIRTUAL_ADAPTER_TABLE);
        for (int i = 0; i < nArray.length; ++i) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)arrayList.get(nArray[i]);
            PIVirtualSlotDataBean pIVirtualSlotDataBean = (PIVirtualSlotDataBean)this.m_virtualAdapters.get(unsignedInt16);
            if (pIVirtualSlotDataBean instanceof PIVirtualEthernetDataBean) {
                if (IDebug.enabled()) {
                    System.err.println("\tVirtual Ethernet: slot " + unsignedInt16);
                }
                PIVirtualEthernetPropertiesDialog pIVirtualEthernetPropertiesDialog = new PIVirtualEthernetPropertiesDialog(userTaskManager, this.m_cimCecBean, (PIVirtualEthernetDataBean)pIVirtualSlotDataBean, this, this.getOccupiedSlotSet(), false, true);
                DialogMapEntry dialogMapEntry = new DialogMapEntry(1, 2, false, pIVirtualSlotDataBean);
                if (this.m_dialogMap.values().contains(dialogMapEntry)) continue;
                this.m_dialogMap.put(pIVirtualEthernetPropertiesDialog.getUserTaskManager(), dialogMapEntry);
                pIVirtualEthernetPropertiesDialog.showDialog();
                continue;
            }
            if (pIVirtualSlotDataBean instanceof PIVirtualSCSIDataBean) {
                if (IDebug.enabled()) {
                    System.err.println("\tVirtual SCSI: slot " + unsignedInt16);
                }
                boolean bl = this.m_cimProfileBean.isOS400Prof() && this.m_cimCecBean.isOS400IoServerCapable() || this.m_cimProfileBean.isIOServerProf();
                PIVirtualSCSIPropertiesDialog pIVirtualSCSIPropertiesDialog = new PIVirtualSCSIPropertiesDialog(userTaskManager, this.m_cimCecBean, (PIVirtualSCSIDataBean)pIVirtualSlotDataBean, this, this.m_lparNamesAndIDs, this.getOccupiedSlotSet(), false, true, bl);
                DialogMapEntry dialogMapEntry = new DialogMapEntry(2, 2, false, pIVirtualSlotDataBean);
                if (this.m_dialogMap.values().contains(dialogMapEntry)) continue;
                this.m_dialogMap.put(pIVirtualSCSIPropertiesDialog.getUserTaskManager(), dialogMapEntry);
                pIVirtualSCSIPropertiesDialog.showDialog();
                continue;
            }
            if (pIVirtualSlotDataBean instanceof PIVirtualSerialDataBean) {
                if (IDebug.enabled()) {
                    System.err.println("\tVirtual serial: slot " + unsignedInt16);
                }
                boolean bl = false;
                int n = unsignedInt16.intValue();
                if (n == 0 || n == 1) {
                    bl = true;
                }
                boolean bl2 = this.m_cimProfileBean.isOS400Prof() || this.m_cimProfileBean.isIOServerProf();
                boolean bl3 = this.m_cimProfileBean.isOS400Prof() && !this.m_cimCecBean.isOS400IoServerCapable();
                PIVirtualSerialPropertiesDialog pIVirtualSerialPropertiesDialog = new PIVirtualSerialPropertiesDialog(userTaskManager, this.m_cimCecBean, (PIVirtualSerialDataBean)pIVirtualSlotDataBean, this, this.m_lparNamesAndIDs, this.getOccupiedSlotSet(), bl, true, bl2, bl3);
                DialogMapEntry dialogMapEntry = new DialogMapEntry(3, 2, bl, pIVirtualSlotDataBean);
                if (this.m_dialogMap.values().contains(dialogMapEntry)) continue;
                this.m_dialogMap.put(pIVirtualSerialPropertiesDialog.getUserTaskManager(), dialogMapEntry);
                pIVirtualSerialPropertiesDialog.showDialog();
                continue;
            }
            if (!IDebug.enabled()) continue;
            System.err.println("\tUnknown: slot " + unsignedInt16);
        }
    }

    public void handleCreate(UserTaskManager userTaskManager) {
        String[] stringArray;
        if (IDebug.enabled()) {
            System.err.println("PIProfileVirtualIODataBean.handleCreate");
        }
        if ((stringArray = userTaskManager.getSelectedElementNames(CREATE_TYPE_GROUP)) == null || stringArray.length != 1) {
            if (IDebug.enabled()) {
                System.err.println("Bad Selection!!!!!!!!!!!!!!!!!!!!!!");
            }
            return;
        }
        if (IDebug.enabled()) {
            System.err.println("CreateTypeGroup selection = " + stringArray[0]);
        }
        if (stringArray[0].endsWith(ETHERNET_BUTTON)) {
            PIVirtualEthernetDataBean pIVirtualEthernetDataBean = new PIVirtualEthernetDataBean();
            PIVirtualEthernetPropertiesDialog pIVirtualEthernetPropertiesDialog = new PIVirtualEthernetPropertiesDialog(userTaskManager, this.m_cimCecBean, pIVirtualEthernetDataBean, this, this.getOccupiedSlotSet(), false, true);
            DialogMapEntry dialogMapEntry = new DialogMapEntry(1, 1, false, pIVirtualEthernetDataBean);
            this.m_dialogMap.put(pIVirtualEthernetPropertiesDialog.getUserTaskManager(), dialogMapEntry);
            pIVirtualEthernetPropertiesDialog.showDialog();
        } else if (stringArray[0].endsWith(SCSI_BUTTON)) {
            boolean bl = this.m_cimProfileBean.isOS400Prof() && this.m_cimCecBean.isOS400IoServerCapable() || this.m_cimProfileBean.isIOServerProf();
            PIVirtualSCSIDataBean pIVirtualSCSIDataBean = new PIVirtualSCSIDataBean();
            PIVirtualSCSIPropertiesDialog pIVirtualSCSIPropertiesDialog = new PIVirtualSCSIPropertiesDialog(userTaskManager, this.m_cimCecBean, pIVirtualSCSIDataBean, this, this.m_lparNamesAndIDs, this.getOccupiedSlotSet(), false, true, bl);
            DialogMapEntry dialogMapEntry = new DialogMapEntry(2, 1, false, pIVirtualSCSIDataBean);
            this.m_dialogMap.put(pIVirtualSCSIPropertiesDialog.getUserTaskManager(), dialogMapEntry);
            pIVirtualSCSIPropertiesDialog.showDialog();
        } else if (stringArray[0].endsWith(SERIAL_BUTTON)) {
            boolean bl = this.m_cimProfileBean.isOS400Prof() || this.m_cimProfileBean.isIOServerProf();
            boolean bl2 = this.m_cimProfileBean.isOS400Prof() && !this.m_cimCecBean.isOS400IoServerCapable();
            PIVirtualSerialDataBean pIVirtualSerialDataBean = new PIVirtualSerialDataBean();
            if ("DLPAR".equals(this.getModule().trim())) {
                pIVirtualSerialDataBean.setModule("DLPAR");
            }
            PIVirtualSerialPropertiesDialog pIVirtualSerialPropertiesDialog = new PIVirtualSerialPropertiesDialog(userTaskManager, this.m_cimCecBean, pIVirtualSerialDataBean, this, this.m_lparNamesAndIDs, this.getOccupiedSlotSet(), false, true, bl, bl2);
            DialogMapEntry dialogMapEntry = new DialogMapEntry(3, 1, false, pIVirtualSerialDataBean);
            this.m_dialogMap.put(pIVirtualSerialPropertiesDialog.getUserTaskManager(), dialogMapEntry);
            pIVirtualSerialPropertiesDialog.showDialog();
        }
    }

    public void handleDelete(UserTaskManager userTaskManager) {
        if (IDebug.enabled()) {
            System.err.println("PIProfileVirtualIODataBean.handleDelete");
        }
        ArrayList arrayList = new ArrayList(this.m_virtualAdapters.keySet());
        int[] nArray = userTaskManager.getSelectedRows(VIRTUAL_ADAPTER_TABLE);
        for (int i = 0; i < nArray.length; ++i) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)arrayList.get(nArray[i]);
            int n = unsignedInt16.intValue();
            if (n == 0 || n == 1) {
                new TaskMessage(userTaskManager, SLOTS_ZERO_AND_ONE_CANNOT_BE_MODIFIED, 1).invoke();
                continue;
            }
            if ("DLPAR".equals(this.getModule().trim())) {
                PIVirtualSlotDataBean pIVirtualSlotDataBean;
                PILPARProfileDataBean pILPARProfileDataBean;
                Object[] objectArray = new Object[]{this.getMOXContainer()};
                try {
                    pILPARProfileDataBean = (PILPARProfileDataBean)this.getMOXContainer().getMOClass().invokeStaticMethod("getLPARProfileDataBean", objectArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    continue;
                }
                SortedMap sortedMap = this.loadSlotsFromProfile(pILPARProfileDataBean);
                if (sortedMap.containsKey(unsignedInt16) && (pIVirtualSlotDataBean = (PIVirtualSlotDataBean)sortedMap.get(unsignedInt16)).getRequired().shortValue() == 2) {
                    new TaskMessage(userTaskManager, CANNOT_REMOVE_REQUIRED_VIRTUAL_SLOT, 1).invoke();
                    continue;
                }
            }
            this.m_virtualAdapters.remove(arrayList.get(nArray[i]));
        }
        userTaskManager.refreshElement(VIRTUAL_ADAPTER_TABLE);
    }

    private ItemDescriptor[] dataBeanToItemDescriptors(PIVirtualSlotDataBean pIVirtualSlotDataBean) {
        ItemDescriptor[] itemDescriptorArray = null;
        UnsignedInt16 unsignedInt16 = pIVirtualSlotDataBean.getSlotNumber();
        if (unsignedInt16 != null) {
            PIVirtualSlotDataBean pIVirtualSlotDataBean2;
            short s;
            int n = unsignedInt16.intValue();
            itemDescriptorArray = new ItemDescriptor[3];
            itemDescriptorArray[0] = new ItemDescriptor("Slot" + n + "SlotNumber", "" + n);
            String string = null;
            string = pIVirtualSlotDataBean instanceof PIVirtualEthernetDataBean ? ETHERNET_ADAPTER : (pIVirtualSlotDataBean instanceof PIVirtualSerialDataBean ? ((s = ((PIVirtualSerialDataBean)(pIVirtualSlotDataBean2 = (PIVirtualSerialDataBean)pIVirtualSlotDataBean)).getDeviceAttributes().shortValue()) == 0 ? CLIENT_SERIAL_ADAPTER : SERVER_SERIAL_ADAPTER) : (pIVirtualSlotDataBean instanceof PIVirtualSCSIDataBean ? ((s = ((PIVirtualSCSIDataBean)(pIVirtualSlotDataBean2 = (PIVirtualSCSIDataBean)pIVirtualSlotDataBean)).getDeviceAttributes().shortValue()) == 0 ? CLIENT_SCSI_ADAPTER : SERVER_SCSI_ADAPTER) : UNKNOWN_ADAPTER));
            itemDescriptorArray[1] = new ItemDescriptor("Slot" + n + "Type", string);
            pIVirtualSlotDataBean2 = pIVirtualSlotDataBean.getRequired();
            s = 1;
            if (pIVirtualSlotDataBean2 != null) {
                s = pIVirtualSlotDataBean2.shortValue();
            }
            String string2 = n + "*Required";
            ItemDescriptor itemDescriptor = null;
            UnsignedInt16 unsignedInt162 = new UnsignedInt16(n);
            if (s == 1) {
                itemDescriptor = new ItemDescriptor(string2, "false");
            } else if (s == 2) {
                itemDescriptor = new ItemDescriptor(string2, "true");
            }
            itemDescriptor.setNotifyComplete(true);
            this.m_utm.addTaskNotifyCompleteListener((TaskNotifyCompleteListener)this, itemDescriptor.getName());
            itemDescriptorArray[2] = itemDescriptor;
        }
        return itemDescriptorArray;
    }

    private PIVirtualSlotDataBean getSlotFromIndex(int n) {
        if (IDebug.enabled()) {
            System.err.println("PIProfileVirtualIODataBean.getSlotFromIndex(" + n + ")");
        }
        ArrayList arrayList = new ArrayList(this.m_virtualAdapters.keySet());
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)arrayList.get(n);
        if (IDebug.enabled()) {
            System.err.println("    getSlotFromIndex(): key = " + unsignedInt16);
        }
        return (PIVirtualSlotDataBean)this.m_virtualAdapters.get(unsignedInt16);
    }

    private SortedSet getOccupiedSlotSet() {
        TreeSet treeSet = new TreeSet(new NumberComparator());
        treeSet.addAll(this.m_virtualAdapters.keySet());
        return treeSet;
    }

    public void taskCompleted(TaskNotifyCompleteEvent taskNotifyCompleteEvent) {
        try {
            String string = taskNotifyCompleteEvent.getElementName();
            String string2 = taskNotifyCompleteEvent.getValue();
            string = string.substring(0, string.indexOf("*"));
            if (string.equalsIgnoreCase("1") || string.equalsIgnoreCase("0")) {
                return;
            }
            PIVirtualSlotDataBean pIVirtualSlotDataBean = null;
            UnsignedInt16 unsignedInt16 = new UnsignedInt16(string);
            pIVirtualSlotDataBean = (PIVirtualSlotDataBean)this.m_virtualAdapters.get(unsignedInt16);
            if (pIVirtualSlotDataBean != null) {
                if (string2.equalsIgnoreCase("true")) {
                    pIVirtualSlotDataBean.setRequired(new UnsignedInt8(2));
                } else {
                    pIVirtualSlotDataBean.setRequired(new UnsignedInt8(1));
                }
                this.m_virtualAdapters.put(unsignedInt16, pIVirtualSlotDataBean);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if ("DLPAR".equals(this.getModule().trim()) && this.m_slotHashtable.get(taskNotifyCompleteEvent.getElementName()) != null) {
            System.err.println("return here");
            return;
        }
    }

    private class DialogMapEntry {
        static final int ETHERNET = 1;
        static final int SCSI = 2;
        static final int SERIAL = 3;
        static final int CREATE = 1;
        static final int PROPERTIES = 2;
        int m_type;
        int m_action;
        boolean m_readOnly;
        PIVirtualSlotDataBean m_cimBean;

        DialogMapEntry(int n, int n2, boolean bl, PIVirtualSlotDataBean pIVirtualSlotDataBean) {
            this.m_type = n;
            this.m_action = n2;
            this.m_readOnly = bl;
            this.m_cimBean = pIVirtualSlotDataBean;
        }

        boolean isEthernet() {
            return this.m_type == 1;
        }

        boolean isSCSI() {
            return this.m_type == 2;
        }

        boolean isSerial() {
            return this.m_type == 3;
        }

        boolean isCreate() {
            return this.m_action == 1;
        }

        boolean isProperties() {
            return this.m_action == 2;
        }

        boolean isReadOnly() {
            return this.m_readOnly;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof DialogMapEntry)) {
                return false;
            }
            DialogMapEntry dialogMapEntry = (DialogMapEntry)object;
            return dialogMapEntry.m_type == this.m_type && dialogMapEntry.m_action == this.m_action && dialogMapEntry.m_cimBean == this.m_cimBean;
        }
    }
}

